[![Codeship Status for peter-featherstone/Responsive-Menu](https://app.codeship.com/projects/0f626140-0c02-0135-749e-1e85f2753028/status?branch=master)](https://app.codeship.com/projects/215186)

# WordPress Responsive Menu Plugin
Highly customisable Responsive Menu Plugin for WordPress. With over 150 customisable options you get a combination of 22,500 options. No coding experience or knowledge is needed with an easy to use interface you can get it looking exactly as you want with minimal fuss.

### See it in action

* [https://responsive.menu](https://responsive.menu)
* [https://demo.responsive.menu](https://demo.responsive.menu)

### Requirements

* PHP 5.4+

### Full Knowledgebase and dedicated support forum

* [https://responsive.menu/knowledgebase/](https://responsive.menu/knowledgebase/)
* [https://responsive.menu/forums/forum/pro-support/](https://responsive.menu/forums/forum/pro-support/)

### Fully unit tested

* 100% unit test coverage with tests included in the plugin so you can run them yourself for peace of mind

### Basic Functionality

* Change every text, background and border colour
* Set the fonts, font sizes and text alignment you want to use
* Set which side and where you want the button to show
* Set which side the menu appears from (left, right, top or bottom)
* Use background image for the menu
* Choice of menu animations (slide over the top or push the content)
* Choice of which Menu to use
* Choice of screen size at which the menu will be shown
* Choice of CSS elements to hide when menu is showing
* Choice of Sub-menu depth to display down to
* Choice of Animation Types & Speeds for the Menu & Button
* Integrated search (fully customisable)
* Ability to disable and re-order the different components
* Ability to fix the button to the top or to let it scroll with the page
* Ability to upload logos, sub-arrow images etc.
* Ability to include Scripts externally, minified and in footer
* Ability to import and export options in a click of a button
* Ability to add custom HTML components
* Ability to choose custom menu triggers
* WPML/Polylang Support
* RTL Support
* Plus much, much more!

### Advanced & Pro Functionality

* Preview your changes before implementing
* Animate the menu items when menu is opened
* FontIcon Support for individual menu items
* 15 button animation effects
* Colour opacity for all colours
* Custom overlay colour and opacity
* Integrated header bar
* Let the plugin provide and style your main menu as well as hamburger menu

### Installation

#### From source:
1. Upload `responsive-menu` to your sites `/wp-content/plugins/` directory.
2. Activate the plugin through the `Plugins` menu in WordPress.
3. Set your options from the Responsive Menu admin area.

#### From the WordPress UI

1. Login to your WordPress admin area
2. Search for `Responsive Menu`
3. Click install `Responsive Menu`
4. Activate through the `Plugins` menu in WordPress or when asked during installation
5. Set your options from the Responsive Menu admin area

### Frequently Asked Questions

To view the FAQ, please go to [https://responsive.menu/faq/](https://responsive.menu/faq/).

### Supported by BrowserStack

Thanks to [BrowserStack](https://browserstack.com/) for their support of this open-source project.

<img src="https://responsive.menu/wp-content/themes/responsive-menu/static/imgs/browserstacklogo.svg" width="150">
