<?php
/*
  $Id$

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2010 osCommerce

  Released under the GNU General Public License
*/

  require('includes/application_top.php');

  require(DIR_WS_LANGUAGES . $language . '/' . FILENAME_PRODUCTS_NEW);

  $breadcrumb->add(NAVBAR_TITLE, tep_href_link(FILENAME_PRODUCTS_NEW));

  require(DIR_WS_INCLUDES . 'template_top.php');
?>
<div class="contentContainer" id="products_new">
	<header><h4><?php echo HEADING_TITLE; ?></h4></header>
	  <div class="products-container portrait product-list">
      	<div class="row">
        	<div class="col-xs-12 col-lg-12">
            <div class="item product-item">
		<?php
  			$products_new_array = array();
  			$products_new_query_raw = "select p.products_id, pd.products_name,pd.products_description, p.products_image, p.products_price, p.products_tax_class_id, p.products_date_added, p.products_model, p.products_weight, 
			m.manufacturers_name from " . TABLE_PRODUCTS . " p left join " . TABLE_MANUFACTURERS . " m on (p.manufacturers_id = m.manufacturers_id), " . TABLE_PRODUCTS_DESCRIPTION 
			. " pd where p.products_status = '1' and p.products_id = pd.products_id and pd.language_id = '" . (int)$languages_id . "' order by p.products_date_added DESC, 
			pd.products_name";
  			$products_new_split = new splitPageResults($products_new_query_raw, MAX_DISPLAY_PRODUCTS_NEW);
  			if (($products_new_split->number_of_rows > 0) && ((PREV_NEXT_BAR_LOCATION == '1') || (PREV_NEXT_BAR_LOCATION == '3'))) {
		?>
    	<div>
      		<span style="float: right;"><?php echo TEXT_RESULT_PAGE . ' <span class="pagination-style">' . $products_new_split->display_links(MAX_DISPLAY_PAGE_LINKS, 
				tep_get_all_get_params(array('page', 'info', 'x', 'y'))); ?></span>
            </span>
      		<span><?php echo $products_new_split->display_count(TEXT_DISPLAY_NUMBER_OF_PRODUCTS_NEW); ?></span>
    	</div>
    	<br />
		<?php
          }
        ?>
        <?php
  			if ($products_new_split->number_of_rows > 0) {
		?>
        <?php
    		$products_new_query = tep_db_query($products_new_split->sql_query);
    			while ($products_new = tep_db_fetch_array($products_new_query)) {
      			if ($new_price = tep_get_products_special_price($products_new['products_id'])) {
       				 $products_price = '<span class="normalprice">' . $currencies->display_price($products_new['products_price'], 
					 	tep_get_tax_rate($products_new['products_tax_class_id'])) . '</span> <span class="productSpecialPrice">' . $currencies->display_price($new_price, 		
						tep_get_tax_rate($products_new['products_tax_class_id'])) . '</span>';
      				} else {
        				$products_price = $currencies->display_price($products_new['products_price'], tep_get_tax_rate($products_new['products_tax_class_id']));
      					}
		?>


	 <?php 
	 $description_new = $products_new['products_description'];	
	 $description = substr ($description_new, 0, 170); 
	 $pid=$products_new['products_id'];
	 
	 $specials_query = tep_db_query("select * from ".TABLE_SPECIALS." where products_id='$pid'");
	 $specials_res = tep_db_fetch_array($specials_query);
	 $feature_query = tep_db_query("select * from ".TABLE_FEATURED." where products_id='$pid'");
	 $featured_res = tep_db_fetch_array($feature_query);
	 $sid=$specials_res['products_id'];
	 $fid=$featured_res['products_id'];
	 
		/*Reviews Query*/
	 	$review_query = tep_db_query("select products_id, reviews_rating from ".TABLE_REVIEWS." where products_id='$pid'");
	 	$review_res = tep_db_fetch_array($review_query);
		if($review_res != NULL) {
	 	$rating_stars =  sprintf(tep_image(DIR_WS_IMAGES . 'stars_' . $review_res['reviews_rating'] . '.gif', 
						sprintf(TEXT_OF_5_STARS,$review_res['reviews_rating'])), sprintf($review_res['reviews_rating']));
		}else {
		 $rating_stars = tep_draw_button(IMAGE_BUTTON_WRITE_REVIEW, 'comment', tep_href_link(FILENAME_PRODUCT_REVIEWS_WRITE, tep_get_all_get_params()), 'primary');
		}

	 if($pid==$sid)
	 {
	    $msg_product="<div class='le-ribbon right orange' title=''><span>Sale</span></div>";
	 }
	 else if($pid==$fid)
	 {
	    $msg_product="<div class='le-ribbon right red' title=''><span>Hot</span></div>";
	 }
	 else
	 {
	    $msg_product="<div class='le-ribbon right blue' title=''><span>New</span></div>";
	 }
	 $product_attribute_query = tep_db_query("select distinct products_id from " . TABLE_PRODUCTS_ATTRIBUTES." where products_id='$pid'");
	 	$product_attribute_query_result = tep_db_fetch_array($product_attribute_query);
	 	$attribute_product=$product_attribute_query_result['products_id'];	
		
		if ($products_new['products_price']== '0'){ //fix for call for price
			$add_cart = '<span>'.TEXT_CALL_FOR_PRICE.'</span>';
		} else if($attribute_product == $pid) {
		$add_cart = tep_draw_button(IMAGE_BUTTON_SELECT_OPTION, 'cart', tep_href_link
					(FILENAME_PRODUCTS_NEW, tep_get_all_get_params(array('action')) 
					. 'action=buy_now&products_id=' . $products_new['products_id']));
		}
		else {
			$add_cart = tep_draw_button(IMAGE_BUTTON_PRODUCT_DETAIL, 'cart', tep_href_link
						(FILENAME_PRODUCTS_NEW, tep_get_all_get_params(array('action')) 
						. 'action=buy_now&products_id=' . $products_new['products_id']));
		}
	 
	 ?>

        	<div class="row product-block list-view product-item wide clearfix">
        		<div class="col-xs-12 col-md-4 no-margin col-sm-4 col-lg-3 img_ar">
                	<div class="head"><?php echo $msg_product;?>
                    	<div class="thumb">
							<?php echo '<a href="' . tep_href_link(FILENAME_PRODUCT_INFO, 'products_id=' . 
                            $products_new['products_id']) . '">' . tep_image(DIR_WS_IMAGES . 
							$products_new['products_image'], $products_new['products_name']) . '</a>'; ?>
                        </div>
                    </div>
                </div>
        		<div class="col-xs-12 col-md-8 no-margin col-sm-8 col-lg-9 des_ar">
					<div class="body ct_lst">
						<h3>
							<?php echo '<a href="' . tep_href_link(FILENAME_PRODUCT_INFO, 'products_id=' . 	
                        	$products_new['products_id']) . '">' . $products_new['products_name'] . '</a>';?>
                        </h3> 
                        <div class="index-ratings"><?php echo $rating_stars; ?></div>
                        <div class="index_price">
                            <?php echo $products_price; ?>
                        </div>
                        <div class="excerpt hidden-xs"> <?php echo $description.'..'; ?></div>
						<div class="product_extra_attributes">
                        	<?php if ($products_new['products_model'] != NULL) { ?>
                            	<div><?php echo PNEW_MODEL;?> : <?php echo $products_new['products_model']; ?></div>
                            <?php } ?>
                            <?php if ($products_new['products_weight'] != 0) { ?>
                            	<div><?php echo PNEW_WEIGHT;?> : <?php echo $products_new['products_weight']; ?></div>
                            <?php } ?>
                            <?php if ($products_new['manufacturers_name'] != NULL) { ?>
                            	<div><?php echo PNEW_MANF;?> : <?php echo $products_new['manufacturers_name']; ?></div>
                    		<?php } ?>
                        </div>
                        <br/>
                        <div class="cart-buttons ckpc"><?php echo $add_cart;?></div>
                    </div>
                    </div>
      			</div>
			<?php
    			}
			?>
			<?php
  			} else {
		?>
                <div>
      				<?php echo TEXT_NO_NEW_PRODUCTS; ?>
    			</div>
            <?php } ?>
  		
		
  	</div>
    </div>
    
  </div>
  <?php if (($products_new_split->number_of_rows > 0) && ((PREV_NEXT_BAR_LOCATION == '2') || (PREV_NEXT_BAR_LOCATION == '3'))) { ?>
    	
  <div class="pageresult_bottom">
      		<div class="product-page-count">
				<div class="navSplitPagesResult">
					<?php echo $products_new_split->display_count(TEXT_DISPLAY_NUMBER_OF_PRODUCTS_NEW); ?>
                </div>
            </div>
      		<div class="navSplitPagesLinks pagination-style"><?php echo $products_new_split->display_links(MAX_DISPLAY_PAGE_LINKS, tep_get_all_get_params(array('page', 'info', 'x', 'y'))); ?></div>
    	</div>
  <?php }?>
  </div>
</div>

<?php
  require(DIR_WS_INCLUDES . 'template_bottom.php');
  require(DIR_WS_INCLUDES . 'application_bottom.php');
?>
